# AI Writer API 白名单插件

这是一个 WordPress 插件，用于解决 SG Security 等安全插件阻止 AI Writer 工具箱 API 请求的问题。

## 安装方法

### 方法一：直接上传 PHP 文件
1. 下载 `ai-writer-api-whitelist.php` 文件
2. 登录 WordPress 后台
3. 进入 **插件** → **安装插件** → **上传插件**
4. 选择下载的文件并上传
5. 激活插件

### 方法二：通过 FTP 上传
1. 下载 `ai-writer-api-whitelist.php` 文件
2. 使用 FTP 客户端连接到您的服务器
3. 将文件上传到 `/wp-content/plugins/` 目录
4. 登录 WordPress 后台，进入 **插件** 页面
5. 找到 "AI Writer API Whitelist" 并激活

### 方法三：直接在 WordPress 创建
1. 登录 WordPress 后台
2. 进入 **插件** → **插件文件编辑器**（如果可用）
3. 创建新文件并粘贴代码
4. 保存并激活

## 配置

激活插件后：
1. 进入 **设置** → **AI Writer API**
2. 可以添加自定义 IP 白名单
3. 可以启用请求日志记录

## 功能

- ✅ 自动将 AI Writer Zeabur 服务器 IP 加入白名单
- ✅ 绕过 SG Security 的 Bot Protection
- ✅ 绕过 Wordfence 的流量检测
- ✅ 确保 REST API 媒体上传正常工作
- ✅ 支持自定义 IP 白名单
- ✅ 可选的请求日志记录

## 默认白名单 IP

- `43.166.139.249` - AI Writer Zeabur 服务器

## 故障排除

如果安装插件后仍然无法正常使用：

1. **检查插件是否激活** - 确保在插件列表中看到 "AI Writer API Whitelist" 处于激活状态

2. **手动添加 IP 到 SG Security**
   - 进入 SG Security → Site Security → Block and Allow IPs
   - 添加 IP: `43.166.139.249`

3. **暂时关闭 Bot Protection**
   - 进入 SG Security → Site Security
   - 关闭 "Bot Protection" 选项

4. **检查日志**
   - 在插件设置中启用日志
   - 查看 `/wp-content/ai-writer-api.log` 文件

## 兼容性

- WordPress 5.0+
- PHP 7.2+
- 兼容 SG Security, Wordfence, iThemes Security 等安全插件

## 许可证

MIT License
